#Scenario A Base

from pyomo.environ import *
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.cm as cm
import os
import pandas as pd
from openpyxl import load_workbook

os.chdir("C:/Users/agusv/Desktop/Estudio/Tesis/Csv")

methodology_A=[]
total_truck_costs_A=[]
total_cooler_costs_A=[]
costs_A = []
truck_emissions_A = []
cooler_emissions_A = []
emissions_A = []
epsilons_A = []
truckquantities_A = []
coolerquantities_A = []

truck_type = ['Diesel_T', 'LNG_T', 'BioLNG_T', 'HVO100_T', 'Electric_T', 'Hydrogen_T']
cooler_type = ['Diesel_C', 'HVO100_C', 'Nitrogen_C','Electric_C']

truck_km = {
    'Diesel_T': 140000,
    'LNG_T': 130000,
    'BioLNG_T': 130000,
    'HVO100_T': 140000,
    'Electric_T': 70000,
    'Hydrogen_T': 100000
}

cooler_h = {
    'Diesel_C': 1896,
    'HVO100_C': 1896,
    'Nitrogen_C':1896,
    'Electric_C': 1896,
}

truck_costs = {
    'Diesel_T': 1.91,
    'LNG_T': 1.76,
    'BioLNG_T':1.8,
    'HVO100_T':1.95,
    'Electric_T':3.22,
    'Hydrogen_T':4.65
    }

cooler_costs = {
    'Diesel_C': 1.91,
    'HVO100_C':1.95,
    'Nitrogen_C': 1.875,
    'Electric_C':3.22
    }
    
truck_emissions_km = {
    "Diesel_T": 0.9956, 
    "LNG_T": 1.118,      
    "BioLNG_T": 0.209,  
    "HVO100_T": 0.3613,
    "Electric_T": 0.0874, 
    "Hydrogen_T": 0.0473 
}

cooler_emissions_h = {
    "Diesel_C": 12.744,
    "HVO100_C": 4.192,
    "Nitrogen_C": 6.072,
    "Electric_C": 0.2464
}

total_km=70000000
budget_azienda=131000000

#For the Single Objective Optimization the Epsilon value is 0 as it is not used in the function for this case.

epsilon_cost_so=0

#Single Objective Optimization for Costs Scenario A.1

def epsilonConstraint(epsilon,truckVector,coolerVector,truck_km,cooler_km,truck_costs,cooler_costs,truck_emissions,cooler_emissions,total_km,budget):
    model = ConcreteModel()
    model.x = Var(truckVector, domain=NonNegativeIntegers)
    model.y = Var(coolerVector, domain=NonNegativeIntegers)
    model.obj = Objective(expr=
                          sum(truck_costs[i]*model.x[i]*truck_km[i] for i in truckVector) +
                          sum(cooler_costs[j]*model.y[j]*cooler_km[j] for j in coolerVector), 
                          sense=minimize
                          )
    model.c1 = Constraint(expr=sum(model.x[i]*truck_km[i] for i in truckVector)>=total_km)
    model.c3 = Constraint(expr=sum(model.x[i] for i in truckVector)==sum(model.y[j] for j in coolerVector))
    model.c4 = Constraint(expr=model.y['Diesel_C'] == model.x['Diesel_T'] + model.x['LNG_T'])
    model.c5 = Constraint(expr=model.y['HVO100_C'] == model.x['HVO100_T'] + 0.25*model.x['BioLNG_T'])
    model.c6 = Constraint(expr=model.y['Nitrogen_C'] == 0.5*model.x['BioLNG_T'])
    model.c7 = Constraint(expr=model.y['Electric_C'] == model.x['Electric_T'] + model.x['Hydrogen_T'] + 0.25*model.x['BioLNG_T'])
    model.c8 = Constraint(expr=model.x['Diesel_T']<=0)
    # EU RED II Target at least 3.5% advanced biofuels for 2030
    model.c13 = Constraint(expr=(
        model.x['BioLNG_T'] * truck_km['BioLNG_T'] + model.x['HVO100_T'] * truck_km['HVO100_T']
        >= 0.035 * sum(model.x[i] * truck_km[i] for i in truckVector)
    ))
    
    # EU RED II Target at least 14% renewables for 2030
    model.c14 = Constraint(expr=(
        model.x['BioLNG_T'] * truck_km['BioLNG_T'] + model.x['HVO100_T'] * truck_km['HVO100_T'] +
        model.x['Electric_T'] * truck_km['Electric_T'] + model.x['Hydrogen_T'] * truck_km['Hydrogen_T']
        >= 0.14 * sum(model.x[i] * truck_km[i] for i in truckVector)
    ))
    
    # Risk management perspective: limit each truck type to <50% of total kilometers
    total_truck_km = sum(model.x[j] * truck_km[j] for j in truck_km.keys())
    
    # Constraints for each truck type
    model.c15 = Constraint(expr=model.x['Diesel_T'] * truck_km['Diesel_T'] <= 0.5 * total_truck_km)
    model.c16 = Constraint(expr=model.x['LNG_T'] * truck_km['LNG_T'] <= 0.5 * total_truck_km)
    model.c17 = Constraint(expr=model.x['BioLNG_T'] * truck_km['BioLNG_T'] <= 0.5 * total_truck_km)
    model.c18 = Constraint(expr=model.x['HVO100_T'] * truck_km['HVO100_T'] <= 0.5 * total_truck_km)
    model.c19 = Constraint(expr=model.x['Electric_T'] * truck_km['Electric_T'] <= 0.5 * total_truck_km)
    model.c20 = Constraint(expr=model.x['Hydrogen_T'] * truck_km['Hydrogen_T'] <= 0.5 * total_truck_km)

    solver = SolverFactory('cplex_direct')
    results = solver.solve(model)
    truck_quantities = {truck: model.x[truck].value for truck in truckVector}
    cooler_quantities = {cooler: model.y[cooler].value for cooler in coolerVector}
    totalkm = sum(model.x[i].value*truck_km[i] for i in truckVector)
    total_cost_truck= sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector)
    total_cost_cooler= sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_cost = sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector) + sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_emissions_truck = sum(model.x[i].value*truck_km[i]*truck_emissions[i] for i in truckVector)
    total_emissions_cooler = sum(model.y[j].value*cooler_km[j]*cooler_emissions[j] for j in coolerVector)
    total_emissions = total_emissions_truck + total_emissions_cooler
    return results,truck_quantities,cooler_quantities,total_cost_truck, total_cost_cooler, total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler       

results_cost_so,truck_quantities_cost_so,cooler_quantities_cost_so,total_cost_truck_cost_so,total_cost_cooler_cost_so, total_cost_cost_so,total_emissions_cost_so,totalkm_cost_so,total_emissions_truck_cost_so,total_emissions_cooler_cost_so  = epsilonConstraint(
    epsilon_cost_so, truck_type, cooler_type, truck_km, cooler_h, truck_costs, cooler_costs, 
    truck_emissions_km, cooler_emissions_h, total_km, budget_azienda
)

#The final emissions value for the epsilon iteration is grabbed from the single optimization process.
single_cost_obj_emissions=total_emissions_cost_so


#Single Objective Optimization for Emissions

def epsilonConstraint(epsilon,truckVector,coolerVector,truck_km,cooler_km,truck_costs,cooler_costs,truck_emissions,cooler_emissions,total_km,budget):
    model = ConcreteModel()
    model.x = Var(truckVector, domain=NonNegativeIntegers)
    model.y = Var(coolerVector, domain=NonNegativeIntegers)
    model.obj = Objective(expr=sum(model.x[i]*truck_km[i]*truck_emissions[i] for i in truckVector) + 
                          sum(model.y[j]*cooler_h[j]*cooler_emissions[j] for j in coolerVector), 
                          sense=minimize
                          )
    model.c1 = Constraint(expr=sum(model.x[i]*truck_km[i] for i in truckVector)>=total_km)
    model.c3 = Constraint(expr=sum(model.x[i] for i in truckVector)==sum(model.y[j] for j in coolerVector))
    model.c4 = Constraint(expr=model.y['Diesel_C'] == model.x['Diesel_T'] + model.x['LNG_T'])
    model.c5 = Constraint(expr=model.y['HVO100_C'] == model.x['HVO100_T'] + 0.25*model.x['BioLNG_T'])
    model.c6 = Constraint(expr=model.y['Nitrogen_C'] == 0.5*model.x['BioLNG_T'])
    model.c7 = Constraint(expr=model.y['Electric_C'] == model.x['Electric_T'] + model.x['Hydrogen_T'] + 0.25*model.x['BioLNG_T'])
    model.c8 = Constraint(expr=model.x['Diesel_T']<=0)
    # EU RED II Target at least 3.5% advanced biofuels for 2030
    model.c13 = Constraint(expr=(
        model.x['BioLNG_T'] * truck_km['BioLNG_T'] + model.x['HVO100_T'] * truck_km['HVO100_T']
        >= 0.035 * sum(model.x[i] * truck_km[i] for i in truckVector)
    ))
    
    # EU RED II Target at least 14% renewables for 2030
    model.c14 = Constraint(expr=(
        model.x['BioLNG_T'] * truck_km['BioLNG_T'] + model.x['HVO100_T'] * truck_km['HVO100_T'] +
        model.x['Electric_T'] * truck_km['Electric_T'] + model.x['Hydrogen_T'] * truck_km['Hydrogen_T']
        >= 0.14 * sum(model.x[i] * truck_km[i] for i in truckVector)
    ))
    
    # Risk management perspective: limit each truck type to <50% of total kilometers
    total_truck_km = sum(model.x[j] * truck_km[j] for j in truck_km.keys())
    
    # Constraints for each truck type
    model.c15 = Constraint(expr=model.x['Diesel_T'] * truck_km['Diesel_T'] <= 0.5 * total_truck_km)
    model.c16 = Constraint(expr=model.x['LNG_T'] * truck_km['LNG_T'] <= 0.5 * total_truck_km)
    model.c17 = Constraint(expr=model.x['BioLNG_T'] * truck_km['BioLNG_T'] <= 0.5 * total_truck_km)
    model.c18 = Constraint(expr=model.x['HVO100_T'] * truck_km['HVO100_T'] <= 0.5 * total_truck_km)
    model.c19 = Constraint(expr=model.x['Electric_T'] * truck_km['Electric_T'] <= 0.5 * total_truck_km)
    model.c20 = Constraint(expr=model.x['Hydrogen_T'] * truck_km['Hydrogen_T'] <= 0.5 * total_truck_km)

    solver = SolverFactory('cplex_direct')
    results = solver.solve(model)
    truck_quantities = {truck: model.x[truck].value for truck in truckVector}
    cooler_quantities = {cooler: model.y[cooler].value for cooler in coolerVector}
    totalkm = sum(model.x[i].value*truck_km[i] for i in truckVector)
    total_cost_truck= sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector)
    total_cost_cooler= sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_cost = sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector) + sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_emissions_truck = sum(model.x[i].value*truck_km[i]*truck_emissions[i] for i in truckVector)
    total_emissions_cooler = sum(model.y[j].value*cooler_km[j]*cooler_emissions[j] for j in coolerVector)
    total_emissions = total_emissions_truck + total_emissions_cooler
    return results,truck_quantities,cooler_quantities,total_cost_truck, total_cost_cooler, total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler       


results,truck_quantities,cooler_quantities,total_cost_truck,total_cost_cooler,total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler  = epsilonConstraint(
    epsilon_cost_so, truck_type, cooler_type, truck_km, cooler_h, truck_costs, cooler_costs, 
    truck_emissions_km, cooler_emissions_h, total_km, budget_azienda
)
methodology_A.append('Environmental Single Objective')
total_truck_costs_A.append(total_cost_truck)
total_cooler_costs_A.append(total_cost_cooler)
costs_A.append(total_cost)
truck_emissions_A.append(total_emissions_truck)
cooler_emissions_A.append(total_emissions_cooler)
emissions_A.append(total_emissions)
epsilons_A.append(epsilon_cost_so)
truckquantities_A.append(truck_quantities)
coolerquantities_A.append(cooler_quantities)

#The initial emissions value for the epsilon iteration is grabbed from the single optimization process.

single_env_obj_emissions=total_emissions

#Scenario A.1

def epsilonConstraint(epsilon,truckVector,coolerVector,truck_km,cooler_km,truck_costs,cooler_costs,truck_emissions,cooler_emissions,total_km,budget):
    model = ConcreteModel()
    model.x = Var(truckVector, domain=NonNegativeIntegers)
    model.y = Var(coolerVector, domain=NonNegativeIntegers)
    model.obj = Objective(expr=
                          sum(truck_costs[i]*model.x[i]*truck_km[i] for i in truckVector) +
                          sum(cooler_costs[j]*model.y[j]*cooler_km[j] for j in coolerVector), 
                          sense=minimize
                          )
    model.c1 = Constraint(expr=sum(model.x[i]*truck_km[i] for i in truckVector)>=total_km)
    model.c2 = Constraint(expr=sum(model.x[i]*truck_km[i]*truck_emissions[i] for i in truckVector) + sum(model.y[j]*cooler_h[j]*cooler_emissions[j] for j in coolerVector)<=epsilon)
    model.c3 = Constraint(expr=sum(model.x[i] for i in truckVector)==sum(model.y[j] for j in coolerVector))
    model.c4 = Constraint(expr=model.y['Diesel_C'] == model.x['Diesel_T'] + model.x['LNG_T'])
    model.c5 = Constraint(expr=model.y['HVO100_C'] == model.x['HVO100_T'] + 0.25*model.x['BioLNG_T'])
    model.c6 = Constraint(expr=model.y['Nitrogen_C'] == 0.5*model.x['BioLNG_T'])
    model.c7 = Constraint(expr=model.y['Electric_C'] == model.x['Electric_T'] + model.x['Hydrogen_T'] + 0.25*model.x['BioLNG_T'])
    model.c8 = Constraint(expr=model.x['Diesel_T']<=0)
    # EU RED II Target at least 3.5% advanced biofuels for 2030
    model.c13 = Constraint(expr=(
        model.x['BioLNG_T'] * truck_km['BioLNG_T'] + model.x['HVO100_T'] * truck_km['HVO100_T']
        >= 0.035 * sum(model.x[i] * truck_km[i] for i in truckVector)
    ))
    
    # EU RED II Target at least 14% renewables for 2030
    model.c14 = Constraint(expr=(
        model.x['BioLNG_T'] * truck_km['BioLNG_T'] + model.x['HVO100_T'] * truck_km['HVO100_T'] +
        model.x['Electric_T'] * truck_km['Electric_T'] + model.x['Hydrogen_T'] * truck_km['Hydrogen_T']
        >= 0.14 * sum(model.x[i] * truck_km[i] for i in truckVector)
    ))
    
    # Risk management perspective: limit each truck type to <50% of total kilometers
    total_truck_km = sum(model.x[j] * truck_km[j] for j in truck_km.keys())
    
    # Constraints for each truck type
    model.c15 = Constraint(expr=model.x['Diesel_T'] * truck_km['Diesel_T'] <= 0.5 * total_truck_km)
    model.c16 = Constraint(expr=model.x['LNG_T'] * truck_km['LNG_T'] <= 0.5 * total_truck_km)
    model.c17 = Constraint(expr=model.x['BioLNG_T'] * truck_km['BioLNG_T'] <= 0.5 * total_truck_km)
    model.c18 = Constraint(expr=model.x['HVO100_T'] * truck_km['HVO100_T'] <= 0.5 * total_truck_km)
    model.c19 = Constraint(expr=model.x['Electric_T'] * truck_km['Electric_T'] <= 0.5 * total_truck_km)
    model.c20 = Constraint(expr=model.x['Hydrogen_T'] * truck_km['Hydrogen_T'] <= 0.5 * total_truck_km)

    solver = SolverFactory('cplex_direct')
    results = solver.solve(model)
    truck_quantities = {truck: model.x[truck].value for truck in truckVector}
    cooler_quantities = {cooler: model.y[cooler].value for cooler in coolerVector}
    totalkm = sum(model.x[i].value*truck_km[i] for i in truckVector)
    total_cost_truck= sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector)
    total_cost_cooler= sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_cost = sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector) + sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_emissions_truck = sum(model.x[i].value*truck_km[i]*truck_emissions[i] for i in truckVector)
    total_emissions_cooler = sum(model.y[j].value*cooler_km[j]*cooler_emissions[j] for j in coolerVector)
    total_emissions = total_emissions_truck + total_emissions_cooler
    return results,truck_quantities,cooler_quantities,total_cost_truck, total_cost_cooler, total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler     

from matplotlib.ticker import ScalarFormatter

epsilon_values = np.geomspace(single_env_obj_emissions, single_cost_obj_emissions, 50)

for epsilon in epsilon_values:
    results,truck_quantities,cooler_quantities,total_cost_truck,total_cost_cooler,total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler  = epsilonConstraint(
        epsilon, truck_type, cooler_type, truck_km, cooler_h, truck_costs, cooler_costs, 
        truck_emissions_km, cooler_emissions_h, total_km, budget_azienda
    )
    methodology_A.append('Multi Objective')
    total_truck_costs_A.append(total_cost_truck)
    total_cooler_costs_A.append(total_cost_cooler)
    costs_A.append(total_cost)
    truck_emissions_A.append(total_emissions_truck)
    cooler_emissions_A.append(total_emissions_cooler)
    emissions_A.append(total_emissions)
    epsilons_A.append(epsilon)
    truckquantities_A.append(truck_quantities)
    coolerquantities_A.append(cooler_quantities)

#After making the multi objective optimization the single economic objective optimization results are added to be graphed.

methodology_A.append('Economic Single Objective')
costs_A.append(total_cost_cost_so)
total_truck_costs_A.append(total_cost_truck_cost_so)
total_cooler_costs_A.append(total_cost_cooler_cost_so)
truck_emissions_A.append(total_emissions_truck_cost_so)
cooler_emissions_A.append(total_emissions_cooler_cost_so)
emissions_A.append(total_emissions_cost_so)
epsilons_A.append(epsilon_cost_so)
truckquantities_A.append(truck_quantities_cost_so)
coolerquantities_A.append(cooler_quantities_cost_so)

#Qualitative Scenario Macroeconomic
#Renewables Mandate


os.chdir("C:/Users/agusv/Desktop/Estudio/Tesis/Csv")

methodology_RENM=[]
total_truck_costs_RENM=[]
total_cooler_costs_RENM=[]
costs_RENM = []
truck_emissions_RENM = []
cooler_emissions_RENM = []
emissions_RENM = []
epsilons_RENM = []
truckquantities_RENM = []
coolerquantities_RENM = []

truck_type = ['Diesel_T', 'LNG_T', 'BioLNG_T', 'HVO100_T', 'Electric_T', 'Hydrogen_T']
cooler_type = ['Diesel_C', 'HVO100_C', 'Nitrogen_C','Electric_C']

truck_km = {
    'Diesel_T': 140000,
    'LNG_T': 130000,
    'BioLNG_T': 130000,
    'HVO100_T': 140000,
    'Electric_T': 70000,
    'Hydrogen_T': 100000
}

cooler_h = {
    'Diesel_C': 1896,
    'HVO100_C': 1896,
    'Nitrogen_C':1896,
    'Electric_C': 1896,
}

truck_costs = {
    'Diesel_T': 1.91,
    'LNG_T': 1.76,
    'BioLNG_T':1.8*1.05,
    'HVO100_T':1.95*1.05,
    'Electric_T':3.22*1.05,
    'Hydrogen_T':4.65
    }

cooler_costs = {
    'Diesel_C': 1.91,
    'HVO100_C':1.95,
    'Nitrogen_C': 1.875,
    'Electric_C':3.22
    }
    
truck_emissions_km = {
    "Diesel_T": 0.9956, 
    "LNG_T": 1.118,      
    "BioLNG_T": 0.209,  
    "HVO100_T": 0.3613,
    "Electric_T": 0.0874, 
    "Hydrogen_T": 0.0473 
}

cooler_emissions_h = {
    "Diesel_C": 12.744,
    "HVO100_C": 4.192,
    "Nitrogen_C": 6.072,
    "Electric_C": 0.2464
}

total_km=70000000
budget_azienda=131000000

#For the Single Objective Optimization the Epsilon value is 0 as it is not used in the function for this case.

epsilon_cost_so=0

#Single Objective Optimization for Costs Scenario A.1

def epsilonConstraint(epsilon,truckVector,coolerVector,truck_km,cooler_km,truck_costs,cooler_costs,truck_emissions,cooler_emissions,total_km,budget):
    model = ConcreteModel()
    model.x = Var(truckVector, domain=NonNegativeIntegers)
    model.y = Var(coolerVector, domain=NonNegativeIntegers)
    model.obj = Objective(expr=
                          sum(truck_costs[i]*model.x[i]*truck_km[i] for i in truckVector) +
                          sum(cooler_costs[j]*model.y[j]*cooler_km[j] for j in coolerVector), 
                          sense=minimize
                          )
    model.c1 = Constraint(expr=sum(model.x[i]*truck_km[i] for i in truckVector)>=total_km)
    model.c3 = Constraint(expr=sum(model.x[i] for i in truckVector)==sum(model.y[j] for j in coolerVector))
    model.c4 = Constraint(expr=model.y['Diesel_C'] == model.x['Diesel_T'] + model.x['LNG_T'])
    model.c5 = Constraint(expr=model.y['HVO100_C'] == model.x['HVO100_T'] + 0.25*model.x['BioLNG_T'])
    model.c6 = Constraint(expr=model.y['Nitrogen_C'] == 0.5*model.x['BioLNG_T'])
    model.c7 = Constraint(expr=model.y['Electric_C'] == model.x['Electric_T'] + model.x['Hydrogen_T'] + 0.25*model.x['BioLNG_T'])
    model.c8 = Constraint(expr=model.x['Diesel_T']<=0)

    # EU RED II Target at least 3.5% advanced biofuels for 2030
    model.c13 = Constraint(expr=(
        model.x['BioLNG_T'] * truck_km['BioLNG_T'] + model.x['HVO100_T'] * truck_km['HVO100_T']
        >= 0.075 * sum(model.x[i] * truck_km[i] for i in truckVector)
    ))
    
    # EU RED II Target at least 14% renewables for 2030
    model.c14 = Constraint(expr=(
        model.x['BioLNG_T'] * truck_km['BioLNG_T'] + model.x['HVO100_T'] * truck_km['HVO100_T'] +
        model.x['Electric_T'] * truck_km['Electric_T'] + model.x['Hydrogen_T'] * truck_km['Hydrogen_T']
        >= 0.25 * sum(model.x[i] * truck_km[i] for i in truckVector)
    ))
    
    # Risk management perspective: limit each truck type to <50% of total kilometers
    total_truck_km = sum(model.x[j] * truck_km[j] for j in truck_km.keys())
    
    # Constraints for each truck type
    model.c15 = Constraint(expr=model.x['Diesel_T'] * truck_km['Diesel_T'] <= 0.5 * total_truck_km)
    model.c16 = Constraint(expr=model.x['LNG_T'] * truck_km['LNG_T'] <= 0.5 * total_truck_km)
    model.c17 = Constraint(expr=model.x['BioLNG_T'] * truck_km['BioLNG_T'] <= 0.5 * total_truck_km)
    model.c18 = Constraint(expr=model.x['HVO100_T'] * truck_km['HVO100_T'] <= 0.5 * total_truck_km)
    model.c19 = Constraint(expr=model.x['Electric_T'] * truck_km['Electric_T'] <= 0.5 * total_truck_km)
    model.c20 = Constraint(expr=model.x['Hydrogen_T'] * truck_km['Hydrogen_T'] <= 0.5 * total_truck_km)

    solver = SolverFactory('cplex_direct')
    results = solver.solve(model)
    truck_quantities = {truck: model.x[truck].value for truck in truckVector}
    cooler_quantities = {cooler: model.y[cooler].value for cooler in coolerVector}
    totalkm = sum(model.x[i].value*truck_km[i] for i in truckVector)
    total_cost_truck= sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector)
    total_cost_cooler= sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_cost = sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector) + sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_emissions_truck = sum(model.x[i].value*truck_km[i]*truck_emissions[i] for i in truckVector)
    total_emissions_cooler = sum(model.y[j].value*cooler_km[j]*cooler_emissions[j] for j in coolerVector)
    total_emissions = total_emissions_truck + total_emissions_cooler
    return results,truck_quantities,cooler_quantities,total_cost_truck, total_cost_cooler, total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler       

results_cost_so,truck_quantities_cost_so,cooler_quantities_cost_so,total_cost_truck_cost_so,total_cost_cooler_cost_so, total_cost_cost_so,total_emissions_cost_so,totalkm_cost_so,total_emissions_truck_cost_so,total_emissions_cooler_cost_so  = epsilonConstraint(
    epsilon_cost_so, truck_type, cooler_type, truck_km, cooler_h, truck_costs, cooler_costs, 
    truck_emissions_km, cooler_emissions_h, total_km, budget_azienda
)

#The final emissions value for the epsilon iteration is grabbed from the single optimization process.
single_cost_obj_emissions=total_emissions_cost_so

#Single Objective Optimization for Emissions

def epsilonConstraint(epsilon,truckVector,coolerVector,truck_km,cooler_km,truck_costs,cooler_costs,truck_emissions,cooler_emissions,total_km,budget):
    model = ConcreteModel()
    model.x = Var(truckVector, domain=NonNegativeIntegers)
    model.y = Var(coolerVector, domain=NonNegativeIntegers)
    model.obj = Objective(expr=sum(model.x[i]*truck_km[i]*truck_emissions[i] for i in truckVector) + 
                          sum(model.y[j]*cooler_h[j]*cooler_emissions[j] for j in coolerVector), 
                          sense=minimize
                          )
    model.c1 = Constraint(expr=sum(model.x[i]*truck_km[i] for i in truckVector)>=total_km)
    model.c3 = Constraint(expr=sum(model.x[i] for i in truckVector)==sum(model.y[j] for j in coolerVector))
    model.c4 = Constraint(expr=model.y['Diesel_C'] == model.x['Diesel_T'] + model.x['LNG_T'])
    model.c5 = Constraint(expr=model.y['HVO100_C'] == model.x['HVO100_T'] + 0.25*model.x['BioLNG_T'])
    model.c6 = Constraint(expr=model.y['Nitrogen_C'] == 0.5*model.x['BioLNG_T'])
    model.c7 = Constraint(expr=model.y['Electric_C'] == model.x['Electric_T'] + model.x['Hydrogen_T'] + 0.25*model.x['BioLNG_T'])
    model.c8 = Constraint(expr=model.x['Diesel_T']<=0)

    # EU RED II Target at least 3.5% advanced biofuels for 2030
    model.c13 = Constraint(expr=(
        model.x['BioLNG_T'] * truck_km['BioLNG_T'] + model.x['HVO100_T'] * truck_km['HVO100_T']
        >= 0.075 * sum(model.x[i] * truck_km[i] for i in truckVector)
    ))
    
    # EU RED II Target at least 14% renewables for 2030
    model.c14 = Constraint(expr=(
        model.x['BioLNG_T'] * truck_km['BioLNG_T'] + model.x['HVO100_T'] * truck_km['HVO100_T'] +
        model.x['Electric_T'] * truck_km['Electric_T'] + model.x['Hydrogen_T'] * truck_km['Hydrogen_T']
        >= 0.25 * sum(model.x[i] * truck_km[i] for i in truckVector)
    ))
    
    # Risk management perspective: limit each truck type to <50% of total kilometers
    total_truck_km = sum(model.x[j] * truck_km[j] for j in truck_km.keys())
    
    # Constraints for each truck type
    model.c15 = Constraint(expr=model.x['Diesel_T'] * truck_km['Diesel_T'] <= 0.5 * total_truck_km)
    model.c16 = Constraint(expr=model.x['LNG_T'] * truck_km['LNG_T'] <= 0.5 * total_truck_km)
    model.c17 = Constraint(expr=model.x['BioLNG_T'] * truck_km['BioLNG_T'] <= 0.5 * total_truck_km)
    model.c18 = Constraint(expr=model.x['HVO100_T'] * truck_km['HVO100_T'] <= 0.5 * total_truck_km)
    model.c19 = Constraint(expr=model.x['Electric_T'] * truck_km['Electric_T'] <= 0.5 * total_truck_km)
    model.c20 = Constraint(expr=model.x['Hydrogen_T'] * truck_km['Hydrogen_T'] <= 0.5 * total_truck_km)

    solver = SolverFactory('cplex_direct')
    results = solver.solve(model)
    truck_quantities = {truck: model.x[truck].value for truck in truckVector}
    cooler_quantities = {cooler: model.y[cooler].value for cooler in coolerVector}
    totalkm = sum(model.x[i].value*truck_km[i] for i in truckVector)
    total_cost_truck= sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector)
    total_cost_cooler= sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_cost = sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector) + sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_emissions_truck = sum(model.x[i].value*truck_km[i]*truck_emissions[i] for i in truckVector)
    total_emissions_cooler = sum(model.y[j].value*cooler_km[j]*cooler_emissions[j] for j in coolerVector)
    total_emissions = total_emissions_truck + total_emissions_cooler
    return results,truck_quantities,cooler_quantities,total_cost_truck, total_cost_cooler, total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler       


results,truck_quantities,cooler_quantities,total_cost_truck,total_cost_cooler,total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler  = epsilonConstraint(
    epsilon_cost_so, truck_type, cooler_type, truck_km, cooler_h, truck_costs, cooler_costs, 
    truck_emissions_km, cooler_emissions_h, total_km, budget_azienda
)
methodology_RENM.append('Environmental Single Objective')
total_truck_costs_RENM.append(total_cost_truck)
total_cooler_costs_RENM.append(total_cost_cooler)
costs_RENM.append(total_cost)
truck_emissions_RENM.append(total_emissions_truck)
cooler_emissions_RENM.append(total_emissions_cooler)
emissions_RENM.append(total_emissions)
epsilons_RENM.append(epsilon_cost_so)
truckquantities_RENM.append(truck_quantities)
coolerquantities_RENM.append(cooler_quantities)

#The initial emissions value for the epsilon iteration is grabbed from the single optimization process.

single_env_obj_emissions=total_emissions

#Scenario A.1

def epsilonConstraint(epsilon,truckVector,coolerVector,truck_km,cooler_km,truck_costs,cooler_costs,truck_emissions,cooler_emissions,total_km,budget):
    model = ConcreteModel()
    model.x = Var(truckVector, domain=NonNegativeIntegers)
    model.y = Var(coolerVector, domain=NonNegativeIntegers)
    model.obj = Objective(expr=
                          sum(truck_costs[i]*model.x[i]*truck_km[i] for i in truckVector) +
                          sum(cooler_costs[j]*model.y[j]*cooler_km[j] for j in coolerVector), 
                          sense=minimize
                          )
    model.c1 = Constraint(expr=sum(model.x[i]*truck_km[i] for i in truckVector)>=total_km)
    model.c2 = Constraint(expr=sum(model.x[i]*truck_km[i]*truck_emissions[i] for i in truckVector) + sum(model.y[j]*cooler_h[j]*cooler_emissions[j] for j in coolerVector)<=epsilon)
    model.c3 = Constraint(expr=sum(model.x[i] for i in truckVector)==sum(model.y[j] for j in coolerVector))
    model.c4 = Constraint(expr=model.y['Diesel_C'] == model.x['Diesel_T'] + model.x['LNG_T'])
    model.c5 = Constraint(expr=model.y['HVO100_C'] == model.x['HVO100_T'] + 0.25*model.x['BioLNG_T'])
    model.c6 = Constraint(expr=model.y['Nitrogen_C'] == 0.5*model.x['BioLNG_T'])
    model.c7 = Constraint(expr=model.y['Electric_C'] == model.x['Electric_T'] + model.x['Hydrogen_T'] + 0.25*model.x['BioLNG_T'])
    model.c8 = Constraint(expr=model.x['Diesel_T']<=0)

    # EU RED II Target at least 3.5% advanced biofuels for 2030
    model.c13 = Constraint(expr=(
        model.x['BioLNG_T'] * truck_km['BioLNG_T'] + model.x['HVO100_T'] * truck_km['HVO100_T']
        >= 0.075 * sum(model.x[i] * truck_km[i] for i in truckVector)
    ))
    
    # EU RED II Target at least 14% renewables for 2030
    model.c14 = Constraint(expr=(
        model.x['BioLNG_T'] * truck_km['BioLNG_T'] + model.x['HVO100_T'] * truck_km['HVO100_T'] +
        model.x['Electric_T'] * truck_km['Electric_T'] + model.x['Hydrogen_T'] * truck_km['Hydrogen_T']
        >= 0.25 * sum(model.x[i] * truck_km[i] for i in truckVector)
    ))
    
    # Risk management perspective: limit each truck type to <50% of total kilometers
    total_truck_km = sum(model.x[j] * truck_km[j] for j in truck_km.keys())
    
    # Constraints for each truck type
    model.c15 = Constraint(expr=model.x['Diesel_T'] * truck_km['Diesel_T'] <= 0.5 * total_truck_km)
    model.c16 = Constraint(expr=model.x['LNG_T'] * truck_km['LNG_T'] <= 0.5 * total_truck_km)
    model.c17 = Constraint(expr=model.x['BioLNG_T'] * truck_km['BioLNG_T'] <= 0.5 * total_truck_km)
    model.c18 = Constraint(expr=model.x['HVO100_T'] * truck_km['HVO100_T'] <= 0.5 * total_truck_km)
    model.c19 = Constraint(expr=model.x['Electric_T'] * truck_km['Electric_T'] <= 0.5 * total_truck_km)
    model.c20 = Constraint(expr=model.x['Hydrogen_T'] * truck_km['Hydrogen_T'] <= 0.5 * total_truck_km)

    solver = SolverFactory('cplex_direct')
    results = solver.solve(model)
    truck_quantities = {truck: model.x[truck].value for truck in truckVector}
    cooler_quantities = {cooler: model.y[cooler].value for cooler in coolerVector}
    totalkm = sum(model.x[i].value*truck_km[i] for i in truckVector)
    total_cost_truck= sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector)
    total_cost_cooler= sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_cost = sum(model.x[i].value*truck_costs[i]*truck_km[i] for i in truckVector) + sum(model.y[j].value*cooler_costs[j]*cooler_km[j] for j in coolerVector)
    total_emissions_truck = sum(model.x[i].value*truck_km[i]*truck_emissions[i] for i in truckVector)
    total_emissions_cooler = sum(model.y[j].value*cooler_km[j]*cooler_emissions[j] for j in coolerVector)
    total_emissions = total_emissions_truck + total_emissions_cooler
    return results,truck_quantities,cooler_quantities,total_cost_truck, total_cost_cooler, total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler     

from matplotlib.ticker import ScalarFormatter

epsilon_values = np.geomspace(single_env_obj_emissions, single_cost_obj_emissions, 50)

for epsilon in epsilon_values:
    results,truck_quantities,cooler_quantities,total_cost_truck,total_cost_cooler,total_cost,total_emissions,totalkm,total_emissions_truck,total_emissions_cooler  = epsilonConstraint(
        epsilon, truck_type, cooler_type, truck_km, cooler_h, truck_costs, cooler_costs, 
        truck_emissions_km, cooler_emissions_h, total_km, budget_azienda
    )
    methodology_RENM.append('Multi Objective')
    total_truck_costs_RENM.append(total_cost_truck)
    total_cooler_costs_RENM.append(total_cost_cooler)
    costs_RENM.append(total_cost)
    truck_emissions_RENM.append(total_emissions_truck)
    cooler_emissions_RENM.append(total_emissions_cooler)
    emissions_RENM.append(total_emissions)
    epsilons_RENM.append(epsilon)
    truckquantities_RENM.append(truck_quantities)
    coolerquantities_RENM.append(cooler_quantities)

#After making the multi objective optimization the single economic objective optimization results are added to be graphed.

methodology_RENM.append('Economic Single Objective')
costs_RENM.append(total_cost_cost_so)
total_truck_costs_RENM.append(total_cost_truck_cost_so)
total_cooler_costs_RENM.append(total_cost_cooler_cost_so)
truck_emissions_RENM.append(total_emissions_truck_cost_so)
cooler_emissions_RENM.append(total_emissions_cooler_cost_so)
emissions_RENM.append(total_emissions_cost_so)
epsilons_RENM.append(epsilon_cost_so)
truckquantities_RENM.append(truck_quantities_cost_so)
coolerquantities_RENM.append(cooler_quantities_cost_so)

#Pareto Frontier

plt.figure(figsize=(12, 8))
colors_A = cm.RdYlGn_r(np.linspace(0, 1, len(epsilon_values)))
colors_RENM = cm.RdYlGn_r(np.linspace(0, 1, len(epsilon_values)))

# Scenario A
for i in range(len(epsilon_values)):
    plt.plot(emissions_A[i], costs_A[i], 'o', color=colors_A[i], label="Scenario A" if i == 0 else "")
plt.plot(emissions_A, costs_A, linestyle='-', color='navy', label='Scenario A (Frontier)')

# Quantitative Scenario A
for i in range(len(epsilon_values)):
    plt.plot(emissions_RENM[i], costs_RENM[i], 'x', color=colors_RENM[i], label="EU RED II Scenario A" if i == 0 else "")
plt.plot(emissions_RENM, costs_RENM, linestyle='--', color='crimson', label='EU RED II Scenario A (Frontier)')

plt.xlabel('Total Emissions (Kg CO2e)', fontsize=20)
plt.ylabel('Total Cost (€)', fontsize=20)
plt.title('Pareto Frontier between Cost and Emissions', fontsize=20, fontweight='bold')

plt.gca().yaxis.set_major_formatter(ScalarFormatter())
plt.gca().xaxis.set_major_formatter(ScalarFormatter())
plt.gca().ticklabel_format(style="plain", axis="both")

plt.legend(fontsize=12)
plt.grid(True, linestyle='--', alpha=0.6)
plt.tight_layout()
plt.show()

# Differences between Scenarios
#Percentual difference in costs
percentual_difference = [(cost_A - cost_RENM) / cost_RENM * 100 for cost_A, cost_RENM in zip(costs_A, costs_RENM)]

plt.figure(figsize=(12, 8))
plt.plot(emissions_A, percentual_difference, marker='o', color='blue', label='Percentual Difference (A - REN)')

plt.xlabel("Total Emissions (Kg CO2e)", fontsize=20)
plt.ylabel("Percentual Difference in Costs (%)", fontsize=20)
plt.title("Percentual Cost Difference (Scenario A - EU RED II Scenario A) Across Emissions", fontsize=20, fontweight='bold')

ax = plt.gca()
ax.xaxis.set_major_formatter(ScalarFormatter())
ax.ticklabel_format(style='plain', axis='x')
ax.xaxis.get_major_formatter().set_scientific(False)

plt.legend(fontsize=12)
plt.grid(True, linestyle='--', alpha=0.6)
plt.tight_layout()
plt.show()

#Truck Quantity Per Iteration

iterations = range(len(truckquantities_A))
truck_types = truck_type

truck_data_A = np.array([[iteration.get(truck, 0) for truck in truck_types] for iteration in truckquantities_A])
truck_data_RENM = np.array([[iteration.get(truck, 0) for truck in truck_types] for iteration in truckquantities_RENM])

colors = cm.get_cmap("tab10", len(truck_types))

plt.figure(figsize=(12, 6))

for i, truck in enumerate(truck_types):
    plt.plot(iterations, truck_data_A[:, i], label=f"{truck} (Scenario A)", color=colors(i), linestyle='-')
    plt.plot(iterations, truck_data_RENM[:, i], label=f"{truck} (EU RED II Scenario A)", color=colors(i), linestyle='--')

plt.title("Truck Quantities Across Iterations")
plt.xlabel("Iterations")
plt.ylabel("Number of Trucks")
plt.legend(loc="upper left", bbox_to_anchor=(1, 1))
plt.tight_layout()
plt.show()

#Coolers per iteration

iterations = range(len(coolerquantities_A))
cooler_types = cooler_type

cooler_data_A = np.array([[iteration.get(cooler, 0) for cooler in cooler_types] for iteration in coolerquantities_A])
cooler_data_RENM = np.array([[iteration.get(cooler, 0) for cooler in cooler_types] for iteration in coolerquantities_RENM])

colors = cm.get_cmap("tab10", len(cooler_types))

plt.figure(figsize=(12, 6))

for i, cooler in enumerate(cooler_types):
    plt.plot(iterations, cooler_data_A[:, i], label=f"{cooler} (Scenario A)", color=colors(i), linestyle='-')
    plt.plot(iterations, cooler_data_RENM[:, i], label=f"{cooler} (EU RED II Scenario A)", color=colors(i), linestyle='--')

plt.title("Cooler Quantities Across Iterations")
plt.xlabel("Iterations")
plt.ylabel("Number of Coolers")
plt.legend(loc="upper left", bbox_to_anchor=(1, 1))
plt.tight_layout()
plt.show()

#Costs per iteration

plt.figure(figsize=(10, 6))
iterations = range(1, len(costs_A) + 1)

plt.plot(iterations, costs_A, label="Total Cost (Scenario A)", linestyle='-', color='blue')
plt.plot(iterations, total_truck_costs_A, label="Truck Cost (Scenario A)", linestyle='--', color='green')
plt.plot(iterations, total_cooler_costs_A, label="Cooler Cost (Scenario A)", linestyle='-.', color='red')

plt.plot(iterations, costs_RENM, label="Total Cost (EU RED II Scenario A)", linestyle='-', color='darkorange')
plt.plot(iterations, total_truck_costs_RENM, label="Truck Cost (EU RED II Scenario A)", linestyle='--', color='olive')
plt.plot(iterations, total_cooler_costs_RENM, label="Cooler Cost (EU RED II Scenario A)", linestyle='-.', color='maroon')

plt.xlabel("Iteration", fontsize=12)
plt.ylabel("Cost (€)", fontsize=12)
plt.title("Cost Comparison Across Iterations", fontsize=14)
plt.legend(fontsize=10)
plt.grid(True, linestyle='--', alpha=0.7)
plt.tight_layout()
plt.show()

#Emissions per iteration

plt.figure(figsize=(10, 6))
iterations = range(1, len(emissions_A) + 1)

plt.plot(iterations, emissions_A, label="Total Emissions (Scenario A)", linestyle='-', color='purple')
plt.plot(iterations, truck_emissions_A, label="Truck Emissions (Scenario A)", linestyle='--', color='orange')
plt.plot(iterations, cooler_emissions_A, label="Cooler Emissions (Scenario A)", linestyle='-.', color='magenta')

plt.plot(iterations, emissions_RENM, label="Total Emissions (EU RED II Scenario A)", linestyle='-', color='violet')
plt.plot(iterations, truck_emissions_RENM, label="Truck Emissions (EU RED II Scenario A)", linestyle='--', color='gold')
plt.plot(iterations, cooler_emissions_RENM, label="Cooler Emissions (EU RED II Scenario A)", linestyle='-.', color='cyan')

plt.xlabel("Iteration", fontsize=12)
plt.ylabel("Emissions (Kg CO2e)", fontsize=12)
plt.title("Emissions Comparison Across Iterations", fontsize=14)
plt.legend(fontsize=10)
plt.grid(True, linestyle='--', alpha=0.7)
plt.tight_layout()
plt.show()

dic_to_excel = [
    {'Methodology': methodology, **d1, **d2, 'Truck Cost': truck_c, 'Cooler Cost': cooler_c,
     'Cost': cost, 'Max_Budget': budget_azienda, 
     'Truck Emissions': truck_em, 'Cooler Emissions': cooler_em, 
     'Emissions': emission, 'Emission Cap': epsilon}
    for methodology, d1, d2, truck_c, cooler_c, cost, emission, epsilon, truck_em, cooler_em 
    in zip(methodology_RENM, truckquantities_RENM, coolerquantities_RENM, total_truck_costs_RENM, total_cooler_costs_RENM, costs_RENM, emissions_RENM, epsilons_RENM, truck_emissions_RENM, cooler_emissions_RENM)
]

al_excel = pd.DataFrame(dic_to_excel)

file_path = 'C:/Users/agusv/Desktop/Estudio/Tesis/Csv/Excel_Files/E_Constraint_Simulation_Scenarios_Alt.xlsx'

try:
    with pd.ExcelWriter(file_path, engine='openpyxl', mode='a', if_sheet_exists='replace') as writer:
        al_excel.to_excel(writer, sheet_name='Scenario EU RED II', index=True)
except FileNotFoundError:
    with pd.ExcelWriter(file_path, engine='openpyxl') as writer:
        al_excel.to_excel(writer, sheet_name='Scenario EU RED II', index=True)

